# Copyright (C) 2013-2021 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 25-Aug-2021 13:17.

"""gasSensorSim2 userdefined profile, originally defined in resource file set
apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import P9000010600000000_4.datapoints.Sensor
import P9000010600000000_4.datapoints.FmkSetup
import izot.resources.datapoints.state
import izot.resources.datapoints.lev_disc
import izot.resources.properties.maxSendTime
import izot.resources.properties.minSendTime
import izot.resources.properties.runHrAlarm


class gasSensorSim2(izot.resources.base.Profile):
    """gasSensorSim2 userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20018,
            scope=4
        )
        self.datapoints['nvoSensor'] = izot.resources.base.Profile.DatapointMember(
            doc="""Boolean """,
            name='nvoSensor',
            profile=self,
            number=1,
            datatype=P9000010600000000_4.datapoints.Sensor.Sensor,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoSetup'] = izot.resources.base.Profile.DatapointMember(
            doc="""Scaling data.  """,
            name='nvoSetup',
            profile=self,
            number=2,
            datatype=P9000010600000000_4.datapoints.FmkSetup.FmkSetup,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviStateTest'] = izot.resources.base.Profile.DatapointMember(
            doc="""State vector.  Each state is a boolean single bit value.
            SNVT_state_64 is preferred.""",
            name='nviStateTest',
            profile=self,
            number=3,
            datatype=izot.resources.datapoints.state.state,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoState'] = izot.resources.base.Profile.DatapointMember(
            doc="""State vector.  Each state is a boolean single bit value.
            SNVT_state_64 is preferred.""",
            name='nvoState',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.state.state,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviErrorTest'] = izot.resources.base.Profile.DatapointMember(
            doc="""State vector.  Each state is a boolean single bit value.
            SNVT_state_64 is preferred.""",
            name='nviErrorTest',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.state.state,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoError'] = izot.resources.base.Profile.DatapointMember(
            doc="""State vector.  Each state is a boolean single bit value.
            SNVT_state_64 is preferred.""",
            name='nvoError',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.state.state,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoAlarm1'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoAlarm1',
            profile=self,
            number=7,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoAlarm2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoAlarm2',
            profile=self,
            number=8,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoWarning'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoWarning',
            profile=self,
            number=9,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoDisabled'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoDisabled',
            profile=self,
            number=10,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoFault'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoFault',
            profile=self,
            number=11,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoMaint'] = izot.resources.base.Profile.DatapointMember(
            doc="""Discrete level.  This SNVT is obsolete.  Use SNVT_switch
            instead.""",
            name='nvoMaint',
            profile=self,
            number=12,
            datatype=izot.resources.datapoints.lev_disc.lev_disc,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['cpMaxSendTime'] = izot.resources.base.Profile.PropertyMember(
            doc="""Maximum send time.  The maximum period of time between
            consecutive transmissions of the current value.""",
            name='cpMaxSendTime',
            profile=self,
            number=1,
            datatype=izot.resources.properties.maxSendTime.maxSendTime,
            default=b'\x00\x00',
            mandatory=True
        )
        self.properties['cpMinSendTime'] = izot.resources.base.Profile.PropertyMember(
            doc="""Minimum send time.  The minimum period of time between
            consecutive transmissions of the current value.""",
            name='cpMinSendTime',
            profile=self,
            number=2,
            datatype=izot.resources.properties.minSendTime.minSendTime,
            default=b'\x00\x00',
            mandatory=True
        )
        self.properties['cpMaintHours'] = izot.resources.base.Profile.PropertyMember(
            doc="""Running hours alarm threshold level.  The alarm threshold
            for the running hours counter.""",
            name='cpMaintHours',
            profile=self,
            number=3,
            datatype=izot.resources.properties.runHrAlarm.runHrAlarm,
            maximum=b'\xff\xff\x17\x00\x00\x00\x00',
            default=b'\x00\x00\x00\x00\x00\x00\x00',
            mandatory=True
        )
        self._original_name = 'UFPTgasSensorSim2'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = gasSensorSim2()
    pass
